using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class DlgModifyAssignments
	/// </summary>
	public class DlgModifyAssignments : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private bool _isLoading = false;
		private bool _isPool = false;

		#region Form Controls

		private System.Windows.Forms.Label lblMessage;
		private System.Windows.Forms.ListView lvPatients;
		private System.Windows.Forms.GroupBox grpPatients;
		private System.Windows.Forms.ColumnHeader columnHeader1;
		private System.Windows.Forms.ColumnHeader columnHeader2;
		private System.Windows.Forms.ColumnHeader columnHeader5;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.ColumnHeader columnHeader3;
		private System.Windows.Forms.ColumnHeader columnHeader4;
		private System.ComponentModel.IContainer components = null;

		#endregion

		/// <summary>
		/// Creates the form for multiple units (Pool)
		/// </summary>
		/// <param name="originalUnits"></param>
		public DlgModifyAssignments(System.Collections.ArrayList originalUnits)
		{
			this._isLoading = true;
			this._isPool = true;

			// This call is required by the Windows Form Designer.
			InitializeComponent();

			SetComponentProperties();

			foreach (BOL.BloodUnit poolingUnit in originalUnits)
			{
				this.PopulateData(poolingUnit);
			}

			this._isLoading = false;
		}

		/// <summary>
		/// Creates the form for one unit
		/// </summary>
		/// <param name="originalUnit"></param>
		public DlgModifyAssignments(BOL.BloodUnit originalUnit)
		{
			this._isLoading = true;

			// This call is required by the Windows Form Designer.
			InitializeComponent();

			SetComponentProperties();

			this.PopulateData(originalUnit);

			this._isLoading = false;

			// **** 508 Compliance ***
			if ( Common.LogonUser.IsVisuallyImpairedUser )
			{
				Common.Utility.Speak( this.lblMessage.Text );
			}
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.lblMessage = new System.Windows.Forms.Label();
			this.lvPatients = new System.Windows.Forms.ListView();
			this.columnHeader5 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader1 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader2 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader3 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader4 = new System.Windows.Forms.ColumnHeader();
			this.grpPatients = new System.Windows.Forms.GroupBox();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.btnCancel = new System.Windows.Forms.Button();
			this.grpPatients.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(500, 30);
			this.vbecsLogo1.TabIndex = 4;
			this.vbecsLogo1.Title = "Assign Modified Units";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 373);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 5;
			// 
			// lblMessage
			// 
			this.lblMessage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblMessage.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.lblMessage.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblMessage.Location = new System.Drawing.Point(8, 36);
			this.lblMessage.Name = "lblMessage";
			this.lblMessage.Size = new System.Drawing.Size(484, 40);
			this.lblMessage.TabIndex = 0;
			this.lblMessage.Text = "Blah blah stuff about the original unit blah.";
			this.lblMessage.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// lvPatients
			// 
			this.lvPatients.AccessibleDescription = "Patients";
			this.lvPatients.AccessibleName = "Patients";
			this.lvPatients.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvPatients.CheckBoxes = true;
			this.lvPatients.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																						 this.columnHeader5,
																						 this.columnHeader1,
																						 this.columnHeader2,
																						 this.columnHeader3,
																						 this.columnHeader4});
			this.lvPatients.FullRowSelect = true;
			this.lvPatients.HideSelection = false;
			this.lvPatients.Location = new System.Drawing.Point(8, 16);
			this.lvPatients.MultiSelect = false;
			this.lvPatients.Name = "lvPatients";
			this.lvPatients.Size = new System.Drawing.Size(464, 203);
			this.lvPatients.TabIndex = 0;
			this.lvPatients.View = System.Windows.Forms.View.Details;
			this.lvPatients.SelectedIndexChanged += new System.EventHandler(this.lvPatients_SelectedIndexChanged);
			this.lvPatients.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.lvPatients_ItemCheck);
			// 
			// columnHeader5
			// 
			this.columnHeader5.Text = "";
			this.columnHeader5.Width = 25;
			// 
			// columnHeader1
			// 
			this.columnHeader1.Text = "Patient Name";
			this.columnHeader1.Width = 80;
			// 
			// columnHeader2
			// 
			this.columnHeader2.Text = "Patient ID";
			// 
			// columnHeader3
			// 
			this.columnHeader3.Text = "Unit ID";
			this.columnHeader3.Width = 80;
			// 
			// columnHeader4
			// 
			this.columnHeader4.Text = "Product";
			this.columnHeader4.Width = 200;
			// 
			// grpPatients
			// 
			this.grpPatients.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpPatients.Controls.Add(this.lvPatients);
			this.grpPatients.Location = new System.Drawing.Point(8, 84);
			this.grpPatients.Name = "grpPatients";
			this.grpPatients.Size = new System.Drawing.Size(484, 227);
			this.grpPatients.TabIndex = 1;
			this.grpPatients.TabStop = false;
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(340, 363);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 2;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(420, 363);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 3;
			this.btnCancel.Text = "&Cancel";
			// 
			// DlgModifyAssignments
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(500, 389);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.grpPatients);
			this.Controls.Add(this.lblMessage);
			this.hlphelpChm.SetHelpKeyword(this, "Modify_Unit.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MinimumSize = new System.Drawing.Size(300, 300);
			this.Name = "DlgModifyAssignments";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Assign Modified Units";
			this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.DlgModifyAssignments_KeyDownSpeakMessage);
			this.Controls.SetChildIndex(this.lblMessage, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.Controls.SetChildIndex(this.grpPatients, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.grpPatients.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion


		///<Developers>
		///	<Developer>Greg</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// OK button click event handler, SetsResult
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void btnOK_Click(object sender, System.EventArgs e)
		{
			this.DialogResult = DialogResult.OK;
			this.Close();
		}

		/// <summary>
		/// GuidArray of Selected Patient assignment -- BloodUnitGuid = [0] PatientGuid = [1]
		/// </summary>
		public System.Guid[] SelectedPatientAssignment
		{
			get
			{
				return((System.Guid[])this.lvPatients.CheckedItems[0].Tag);
			}
		}


		private void SetComponentProperties()
		{
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");

			this.btnOK.EnabledButton = false;

			if (this._isPool)
			{
				this.lblMessage.Text = Common.StrRes.ValidMsg.UC026.BR25PatientAssignmentPool().ResString;
				this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC024.DlgModifyAssignments());
			}
			else
			{
				this.lblMessage.Text = Common.StrRes.ValidMsg.UC026.BR25PatientAssignmentSingle().ResString;
				this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC026.DlgModifyAssignments());
			}

			this.lvPatients.Items.Clear();

			this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.SelectOneItem("patient").ResString);
			this.ttToolTip.SetToolTip(this.btnCancel, Common.StrRes.Tooltips.UC026.PatientAssignmentCancel().ResString);
			this.ttToolTip.SetToolTip(this.lvPatients, Common.StrRes.Tooltips.UC026.PatientAssignmentListview().ResString);
		}

		private void PopulateData(BOL.BloodUnit originalUnit)
		{
			for (int ndx=0; ndx < originalUnit.AssignedToPatients.Count; ndx++)
			{
				System.Collections.Hashtable hashGuids = new Hashtable();

				BOL.Patient tmpPatient = (BOL.Patient)originalUnit.AssignedToPatients[ndx];

				System.Guid[] guidArray = {originalUnit.BloodUnitGuid, tmpPatient.PatientGuid};

				ListViewItem lviPatient = new ListViewItem();

				lviPatient.Checked = false;
				lviPatient.Tag = guidArray;

				lviPatient.SubItems.Add(tmpPatient.DisplayName);
				lviPatient.SubItems.Add(tmpPatient.DisplayPatientID);

				lviPatient.SubItems.Add(originalUnit.EyeReadableUnitId);
				lviPatient.SubItems.Add(originalUnit.ProductName);
				
				this.lvPatients.Items.Add(lviPatient);

			}

			controls.VbecsFunction.SetColumnWidths(this.lvPatients);
		}

		private void lvPatients_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
			if (this._isLoading) return;
			
			if (e.NewValue == CheckState.Checked)
			{
				foreach(ListViewItem lvi in this.lvPatients.CheckedItems)
				{
					lvi.Checked = false;
				}
			}

			bool enableOK = (e.NewValue == CheckState.Checked);

			this.btnOK.EnabledButton = enableOK;

			if (enableOK)
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.UC026.PatientAssignmentOK().ResString);
			else
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.SelectPatient().ResString);

		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void DlgModifyAssignments_KeyDownSpeakMessage(object sender, EventArgs e)
		{
			if ( !this.btnOK.EnabledButton )
			{
				this.SpeakMessage( this.btnOK.GetToolTip() );
			}
		}

		private void lvPatients_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			this.SpeakListViewWithCheckBox(lvPatients);
		}
	}
}

